/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: DPM_Struct.h 1892 2014-10-08 06:50:54Z stephans $:

  Description:
    netX DPM definitions

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2010-03-24  File created.

**************************************************************************************/


#ifndef _DPM_STRUCT_H
#define _DPM_STRUCT_H


/*************************************************************************************/


/* structure map of netX GPIO registers */

typedef struct NETX_DPM_IRQ_REGISTERS_Ttag
{
  volatile unsigned long aulIrqStatus[4];
  volatile unsigned long aulIrqEnable[4];
} NETX_DPM_IRQ_REGISTERS_T;

typedef struct NETX_DPM_MAPPING_BLOCK_Ttag
{
  volatile unsigned long ulEndAddress;
  volatile unsigned long ulMapAddress;
} NETX_DPM_MAPPING_BLOCK_T;

typedef struct NETX_DPM_ARM_GLOBAL_REG_BLOCK_Ttag
{
  volatile unsigned long ulReserved;
  volatile unsigned long ulClockOutReg;
  volatile unsigned long ulIfConf[2];
  volatile unsigned long ulExpBusReg;
  volatile unsigned long aulReserved[3];
  volatile unsigned long ulIoRegMode0;
  volatile unsigned long ulIoRegDriverEnable0;
  volatile unsigned long ulIoRegData0;
  volatile unsigned long ulIoRegReserved0;
  volatile unsigned long ulIoRegMode1;
  volatile unsigned long ulIoRegDriverEnable1;
  volatile unsigned long ulIoRegData1;
  volatile unsigned long ulIoRegReserved1;
  NETX_DPM_MAPPING_BLOCK_T  atBlockMap[8];
  volatile unsigned long ulHandshakeControl[16];
} NETX_DPM_ARM_GLOBAL_REG_BLOCK_T;

#endif
